/******************************************************************************
 x_CExecuteOptions.c

				CExecuteOptions Dialog Director Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory)

	This file is rewritten each time you generate code. You should not
	make changes to this file; changes should go in the CExecuteOptions.c
	file, instead.

	If you want to change how Classy generates this file, you can
	change the template for this file. It is "_Dialog.c" in the Classy
	Templates folder.

 ******************************************************************************/

#include "x_CExecuteOptions.h"

#include "ExecuteOptionsItems.h"

#include "ViewUtilities.h"

#include <CIntegerText.h>
#include <Commands.h>
#include <CControl.h>
#include <CPopup.h>
#include <CPopupPane.h>
#include <CArrayPane.h>
#include <CIconButton.h>
#include <CPictureButton.h>
#include <CSwissArmyButton.h>

#include "CRectOvalButton.h"
#include "CStaticText.h"
#include "CButtonProc.h"
#include "CCheckBoxProc.h"
#include "CRadioControlProc.h"
#include "CDialogText.h"


#include <CApplication.h>
#include <CBartender.h>
#include <Commands.h>
#include <Constants.h>
#include <CDecorator.h>
#include <CDesktop.h>
#include <CDirectorOwner.h>
#include <CFile.h>
#include <CList.h>
#include <CPanorama.h>
#include <TBUtilities.h>
#include <CWindow.h>

extern	CApplication *gApplication;		/* The application					*/
extern CDecorator	*gDecorator;		/* Decorator for arranging windows	*/
extern CDesktop		*gDesktop;			/* The visible Desktop				*/
extern CBartender	*gBartender;		/* Manages all menus				*/

	// Define symbols for commands handled by this class
	// Prevents a recompile every time any command changed.

#define cmdBindOne 542
#define cmdExecuteOne 543

/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


/******************************************************************************
 Ix_CExecuteOptions

	Initialize the dialog
 ******************************************************************************/

void x_CExecuteOptions::Ix_CExecuteOptions(CDirectorOwner *aSupervisor)

{
	IDialogDirector(aSupervisor);

		// There are several circumstances where we don't want
		// ProviderChanged to be called. During initialization,
		// during calls to UpdateData, etc. The ignore flag
		// heads these off.

	ignore = TRUE;						/* Don't call UpdateData now		*/

	MakeNewWindow();					/* Create the dialog's window		*/

	DoBeginData();						/* Gather initial values			*/

	ignore = FALSE;
}


/******************************************************************************
 MakeNewWindow

	Create a window by reading a view resource
 ******************************************************************************/

void x_CExecuteOptions::MakeNewWindow(void)

{
	itsWindow = CLGetNamedWindow("\pExecuteOptions", this);

		// Initialize pointers to the subpanes in the window

  fExecuteOptions_Rect27 = (CRectOvalButton*) FindPane(kExecuteOptions_Rect27ID);
  ASSERT(member(fExecuteOptions_Rect27, CRectOvalButton));

  fExecuteOptions_Stat22 = (CStaticText*) FindPane(kExecuteOptions_Stat22ID);
  ASSERT(member(fExecuteOptions_Stat22, CStaticText));

  fExecuteOptions_Rect20 = (CRectOvalButton*) FindPane(kExecuteOptions_Rect20ID);
  ASSERT(member(fExecuteOptions_Rect20, CRectOvalButton));

  fExecuteOptions_Butn1 = (CButtonProc*) FindPane(kExecuteOptions_Butn1ID);
  ASSERT(member(fExecuteOptions_Butn1, CButtonProc));

  fExecuteOptions_Butn2 = (CButtonProc*) FindPane(kExecuteOptions_Butn2ID);
  ASSERT(member(fExecuteOptions_Butn2, CButtonProc));

  fExecuteOptions_Source = (CCheckBoxProc*) FindPane(kExecuteOptions_SourceID);
  ASSERT(member(fExecuteOptions_Source, CCheckBoxProc));

  fExecuteOptions_Routines = (CCheckBoxProc*) FindPane(kExecuteOptions_RoutinesID);
  ASSERT(member(fExecuteOptions_Routines, CCheckBoxProc));

  fExecuteOptions_Exception = (CCheckBoxProc*) FindPane(kExecuteOptions_ExceptionID);
  ASSERT(member(fExecuteOptions_Exception, CCheckBoxProc));

  fExecuteOptions_Rendezvous = (CCheckBoxProc*) FindPane(kExecuteOptions_RendezvousID);
  ASSERT(member(fExecuteOptions_Rendezvous, CCheckBoxProc));

  fExecuteOptions_Task = (CCheckBoxProc*) FindPane(kExecuteOptions_TaskID);
  ASSERT(member(fExecuteOptions_Task, CCheckBoxProc));

  fExecuteOptions_Stat19 = (CStaticText*) FindPane(kExecuteOptions_Stat19ID);
  ASSERT(member(fExecuteOptions_Stat19, CStaticText));

  fExecuteOptions_Robin = (CRadioControlProc*) FindPane(kExecuteOptions_RobinID);
  ASSERT(member(fExecuteOptions_Robin, CRadioControlProc));

  fExecuteOptions_Block = (CRadioControlProc*) FindPane(kExecuteOptions_BlockID);
  ASSERT(member(fExecuteOptions_Block, CRadioControlProc));

  fExecuteOptions_Size = (CDialogText*) FindPane(kExecuteOptions_SizeID);
  ASSERT(member(fExecuteOptions_Size, CDialogText));

  fExecuteOptions_Stat26 = (CStaticText*) FindPane(kExecuteOptions_Stat26ID);
  ASSERT(member(fExecuteOptions_Stat26, CStaticText));

}


/******************************************************************************
 FindPane

	Locate a subpane of this window by ID. Note that Classy-
	generated IDs are unique within a project, so this function
	will find panes within subviews, even if dynamically loaded.
 ******************************************************************************/

CPane *x_CExecuteOptions::FindPane(long ID)

{
	return (CPane*) itsWindow->FindViewByID(ID);
}


/******************************************************************************
 DoBeginData
 
 	Collect initial values from subclass and initialize panes
******************************************************************************/

void x_CExecuteOptions::DoBeginData()

{
	CExecuteOptionsData		data = {0};		/* The initial value record			*/

	BeginData(&data);					/* Ask subclass for initial values	*/

		// Initialize the panes based on the values supplied.
		// The ASSERT statements ensure that the generated
		// code is in synch with the view resource.

	fExecuteOptions_Source->SetValue(data.fExecuteOptions_Source);

	fExecuteOptions_Routines->SetValue(data.fExecuteOptions_Routines);

	fExecuteOptions_Exception->SetValue(data.fExecuteOptions_Exception);

	fExecuteOptions_Rendezvous->SetValue(data.fExecuteOptions_Rendezvous);

	fExecuteOptions_Task->SetValue(data.fExecuteOptions_Task);

	fExecuteOptions_Robin->SetValue(data.fExecuteOptions_Robin);

	fExecuteOptions_Block->SetValue(data.fExecuteOptions_Block);

    fExecuteOptions_Size->SetTextString(data.fExecuteOptions_Size);

		// Save the initial values in case user cancels

	saveData = data;
}


/******************************************************************************
 DoEndData
 
 	Collect final values from panes and tell subclass
******************************************************************************/

void x_CExecuteOptions::DoEndData(long theCommand)

{
	CExecuteOptionsData		data;			/* The initial value record			*/
	RgnHandle			rgn;			/* Selection region					*/

										/* If user canceled the dialog,		*/
	if (theCommand == cmdCancel)		/*	 return the initial values		*/
	{
		data = saveData;
		EndData(&data);
		return;
	}

										/* Collect values from panes		*/
    data.fExecuteOptions_Source = fExecuteOptions_Source->GetValue();

    data.fExecuteOptions_Routines = fExecuteOptions_Routines->GetValue();

    data.fExecuteOptions_Exception = fExecuteOptions_Exception->GetValue();

    data.fExecuteOptions_Rendezvous = fExecuteOptions_Rendezvous->GetValue();

    data.fExecuteOptions_Task = fExecuteOptions_Task->GetValue();

    data.fExecuteOptions_Robin = fExecuteOptions_Robin->GetValue();

    data.fExecuteOptions_Block = fExecuteOptions_Block->GetValue();

    fExecuteOptions_Size->GetTextString(data.fExecuteOptions_Size);


	EndData(&data);
}


/******************************************************************************
 BeginData
 
 	Collect initial values from subclass and initialize panes
******************************************************************************/

void x_CExecuteOptions::BeginData(CExecuteOptionsData *initial)

{
}


/******************************************************************************
 UpdateData
 
 	Tell subclass when panes change
******************************************************************************/

void x_CExecuteOptions::UpdateData(CExecuteOptionsUpdate *update, long itemNo)

{
}


/******************************************************************************
 EndData
 
 	Tell subclass the final values. For a canceled modal dialog,
 	these are the same as the initial values.
******************************************************************************/

void x_CExecuteOptions::EndData(CExecuteOptionsData *final)

{
}


/******************************************************************************
 DoModalDialog	{OVERRIDE}
 
 	Override to call EndData
******************************************************************************/

long x_CExecuteOptions::DoModalDialog(long defaultCmd)

{
	long	result = CDialogDirector::DoModalDialog(defaultCmd);
	
	DoEndData(result);
	return result;
}


/******************************************************************************
 Close {OVERRIDE}
 
 	Override to call EndData
******************************************************************************/

Boolean x_CExecuteOptions::Close(Boolean quitting)

{	
	if (itsWindow && !itsWindow->active)
		itsWindow->Select();

	if (EndDialog(cmdOK, TRUE))
	{										
										/* For a modal dialog, exit through	*/
		if (itsWindow->IsModal())		/*	 DoModalDialog					*/
		{
			dismissCmd = cmdClose;
			return TRUE;
		}
		else
		{
										/* Collect final values and call	*/
			DoEndData(cmdOK);			/*	 EndData						*/
										/* Do the Close						*/
			return CDirector::Close(quitting);
		}
	}
	else
		return FALSE;
}


/******************************************************************************
 ProviderChanged	{OVERRIDE}
 	
 	User did something. Note that the TCL
 	does not currently report changes to plain CEditText items. 
******************************************************************************/

void x_CExecuteOptions::ProviderChanged(CCollaborator *aProvider, long reason, void* info)

{
	CExecuteOptionsUpdate	data;			/* The update value record			*/
	Str255	str;
	Boolean	saveIgnore = ignore;
	
	if (ignore)							/* Don't be a chatterbox			*/
		return;
	ignore = TRUE;
	
	TRY
	{
 		if (FALSE) {}
		else if (reason == controlValueChanged
				&& aProvider == fExecuteOptions_Source)
		{
			data.value = *(short*) info;
			UpdateData(&data, kExecuteOptions_SourceID);
		}
		else if (reason == controlValueChanged
				&& aProvider == fExecuteOptions_Routines)
		{
			data.value = *(short*) info;
			UpdateData(&data, kExecuteOptions_RoutinesID);
		}
		else if (reason == controlValueChanged
				&& aProvider == fExecuteOptions_Exception)
		{
			data.value = *(short*) info;
			UpdateData(&data, kExecuteOptions_ExceptionID);
		}
		else if (reason == controlValueChanged
				&& aProvider == fExecuteOptions_Rendezvous)
		{
			data.value = *(short*) info;
			UpdateData(&data, kExecuteOptions_RendezvousID);
		}
		else if (reason == controlValueChanged
				&& aProvider == fExecuteOptions_Task)
		{
			data.value = *(short*) info;
			UpdateData(&data, kExecuteOptions_TaskID);
		}
		else if (reason == controlValueChanged
				&& aProvider == fExecuteOptions_Robin)
		{
			data.value = *(short*) info;
			UpdateData(&data, kExecuteOptions_RobinID);
		}
		else if (reason == controlValueChanged
				&& aProvider == fExecuteOptions_Block)
		{
			data.value = *(short*) info;
			UpdateData(&data, kExecuteOptions_BlockID);
		}
		else if (reason == dialogTextChanged
				&& aProvider == fExecuteOptions_Size)
		{
			((CDialogText*) aProvider)->GetTextString(data.stringvalue);
			UpdateData(&data, kExecuteOptions_SizeID);
  		}
		else
			CDialogDirector::ProviderChanged(aProvider, reason, info);
	}
	CATCH
		ignore = saveIgnore;
	ENDTRY
	
	ignore = saveIgnore;				/* ProviderChanged() can't Close()!	*/
}


/******************************************************************************
 DoCommand {OVERRIDE}

		Dispatch Classy-specified actions.
 ******************************************************************************/

void x_CExecuteOptions::DoCommand(long theCommand)

{
	switch (theCommand)
	{
		case cmdBindOne:
			DoCmdBindOne();
			break;
		case cmdExecuteOne:
			DoCmdExecuteOne();
			break;
		default:
			CDialogDirector::DoCommand(theCommand);
	}
}


/******************************************************************************
 UpdateMenus {OVERRIDE}

		Enable menus which generate commands handled by this class.
 ******************************************************************************/

void x_CExecuteOptions::UpdateMenus()

{
	CDialogDirector::UpdateMenus();
	gBartender->EnableCmd(cmdBindOne);
	gBartender->EnableCmd(cmdExecuteOne);
}


/******************************************************************************
 DoCmdBindOne

		Respond to cmdBindOne command.
 ******************************************************************************/

void x_CExecuteOptions::DoCmdBindOne()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdExecuteOne

		Respond to cmdExecuteOne command.
 ******************************************************************************/

void x_CExecuteOptions::DoCmdExecuteOne()

{
  		// Subclass must override this function to
  		// handle the command
}


